 ; Ŀ
 ;   Phdel - delete all frozen layers in a drawing.                        
 ;   Copyright 1997, 2008 by Rocket Software Ltd.                          
 ;   A picture is worth a thousand words, especially if it has a caption.  
 ; 
 (DEFUN C:PHDEL (/ rew layy sev namm ss)
  (setvar "cmdecho" 0)
  (setq rew t)
  (while (setq layy (tblnext "layer" rew))
         (setq rew ())
         (setq sev (cdr (assoc 70 layy)))
         (if (and sev (= (logand 1 sev) 1))
             (progn
                  (setq namm (cdr (assoc 2 layy)))
                  (command "layer" "thaw" namm "")
                  (if (setq ss (ssget "x" (list (cons 8 namm))))
                      (command "erase" ss ""))
                  (command "-purge" "layer" namm "n")
 ; Ŀ
 ;   If the layer still exists then there must be something on it,         
 ;   so freeze it again.                                                   
 ; 
                  (if (tblsearch "layer" namm)
                      (command "layer" "freeze" namm "")))))
 (princ))

